DEFINE CLASS vfpStretch as Custom
*=*
*FUNCTION Init
*=*
	FUNCTION Init
		IF TYPE('_screen.CurrentZoom') = 'U'
			=ADDPROPERTY(_screen, 'CurrentZoom',0)
		ENDIF
	ENDFUNC
	
	FUNCTION Do(toThisForm)
		LOCAL lcPropName as String
		lcPropName = SYS(2015)
		=ADDPROPERTY(toThisform,lcPropName, CREATEOBJECT("Stretcher"))
		toThisform.&lcPropName..Do(tothisform)
	ENDFUNC
ENDDEFINE
*=
*Stretcher Class
*=
DEFINE CLASS Stretcher As Custom
	nOriginalHeight =0
	nOriginalWidth =0
	oForm = .null.
*=
*FUNCTION DO
*=
FUNCTION DO(toThisform)
	With this
	
		.oForm = toThisform	
		&&SET STEP ON
			
		IF TYPE(".oForm")!='O'
			.oForm =iif(TYPE('_Screen.ActiveForm')=='O',_Screen.ActiveForm,.Null.)
			IF ISNULL(.oForm)
				MESSAGEBOX("You must create VfpStretch object inside a form!",48,"Warning!")
				RETURN .F.
			ENDIF
		ENDIF
	
		.oForm.MinHeight= .oForm.Height
		.oForm.MinWidth= .oForm.Width

		.nOriginalHeight = .oForm.Height
		.nOriginalWidth = .oForm.Width
		.SaveContainer(.oForm)
		
		=BINDEVENT(.oForm, "Resize", This, "Stretch", 1)
		.Zoom()
	ENDWITH
ENDFUNC
*=
*=
*Function ResetSize
	FUNCTION ResetSize
		WITH this.oform
			.Height =This.nOriginalheight
			.wIDTH = This.nOriginalWidth
		ENDWITH
	endfunc
*=
*=
*Function SaveContainer
*=
FUNCTION SaveContainer
	LPARAMETERS oContainer
	WITH This
		LOCAL oThis
		.SaveOriginalSize(m.oContainer)
		FOR EACH m.oThis IN m.oContainer.Controls
			IF m.oThis.Tag<>"NOSTRETCH"

				IF !m.oThis.BaseClass == 'Custom'
					.SaveOriginalSize(m.oThis)
				ENDIF
				
				IF TYPE("m.oThis.Anchor")= "N" AND m.oThis.Anchor>0
					m.oThis.Anchor=0

				ENDIF
				
				Do Case
				CASE m.oThis.BaseClass == 'Container'
					.SaveContainer(m.oThis)
				CASE m.oThis.BaseClass == 'Pageframe'
					LOCAL oPage&&,oPage2
					FOR EACH oPage IN m.oThis.pages
						.SaveContainer(m.oPage)
						&&FOR EACH m.oPage2 IN oPage.BaseClass=='Grid'	
									&&MESSAGEBOX(m.oPage2.BaseClass)
						&&.SaveContainer(m.oPage2)
						&&endfor
					ENDFOR
				CASE m.oThis.BaseClass == 'Grid'
					LOCAL oColumn
					FOR EACH oColumn IN m.oThis.Columns
						.SaveOriginalSize(m.oColumn)

					ENDFOR
				CASE m.oThis.BaseClass $ 'Commandgroup,OptionGroup'

					LOCAL oButton
					FOR EACH oButton IN m.oThis.Buttons
						.SaveOrignalSize(m.oButton)

					ENDFOR
				ENDCASE
			ENDIF
		ENDFOR
	ENDWITH
ENDFUNC
*=
*=
*Function SaveOriginalSize
*=
FUNCTION SaveOriginalSize
	LPARAMETERS oObject
	IF PEMSTATUS(m.oObject, 'Width', 5)	
		if!PEMSTATUS(m.oObject,'_nOriginalWidth',5)		
			=ADDPROPERTY(m.oObject,"_nOriginalWidth",m.oObject.Width)
		ENDIF
		
		IF PEMSTATUS(m.oObject,'Height',5)	
			if!PEMSTATUS(m.oObject,'_nOriginalHeight',5)		
				=ADDPROPERTY(m.oObject,"_nOriginalHeight",m.oObject.Height)
			ENDIF
			IF !PEMSTATUS(m.oObject,'_nOriginalLeft',5)
				=ADDPROPERTY(m.oObject,"_nOriginalLeft",m.oObject.Left)
			ENDIF
			IF !PEMSTATUS(m.oObject,'_nOriginalTop',5)
				=ADDPROPERTY(m.oObject,"_nOriginalTop",m.oObject.Top)
			ENDIF
		ENDIF
	ENDIF
	IF PEMSTATUS(m.oObject,'fontsize',5)
		=ADDPROPERTY(m.oObject,"_nOriginalFontsize",m.oObject.FontSize)
	endif
	IF PEMSTATUS(m.oObject,'RowHeight',5)
		=ADDPROPERTY(m.oObject,"_nOriginalRowheight",m.oObject.RowHeight)
	ENDIF
ENDFUNC
*=
*=Function Stretch
*=
FUNCTION Stretch
	LPARAMETERS oContainer
	WITH This
		IF TYPE("oContainer")!="O"
			oContainer=.oForm
		ENDIF
		&&MESSAGEBOX(m.oThis.BaseClass)
		&&MESSAGEBOX(VARTYPE(m.oThis))
		LOCAL oThis
		IF m.oContainer.BaseClass == 'Form'
		m.oContainer.LockScreen=.T.
		ELSE
			.AdjustSize(m.oContainer)
		ENDIF
		FOR EACH m.oThis IN m.oContainer.Controls

			If!m.oThis.BaseClass == 'Custom'
				.AdjustSize(m.oThis)
			ENDIF
			&&&MESSAGEBOX(m.oContainer.BaseClass)
			DO Case
			CASE m.oThis.BaseClass == 'Container'
				.Stretch(m.oThis)
			CASE m.oThis.BaseClass == 'Pageframe'
				LOCAL oPage
				FOR EACH oPage IN m.oThis.Pages
					.Stretch(m.oPage)
				ENDFOR
			CASE m.oThis.BaseClass == 'Grid'
				LOCAL oColumn
				FOR EACH oColum IN m.oThis.Columns
					.AdjustSize(m.oColumn)
				ENDFOR
			CASE m.oThis.BaseClass $ 'Commandgroup,OptionGroup'
			LOCAL oButton
				FOR EACH oButton IN m.oThis.Buttons
				.AdjustSize(m.oButton)
				ENDFOR
			ENDCASE
		ENDFOR
		IF m.oContainer.BaseClass == 'Form'
			m.oContainer.LockScreen =.F.
		ENDIF
	ENDWITH
ENDFUNC
*=
*=
*Function AdjustSize
*=
 FUNCTION AdjustSize
	 LPARAMETERS oObject
	 LOCAL nHeightRatio, nWidthRatio
	 m.nHeightRatio = This.oForm.Height / This.nOriginalHeight
	 m.nWidthRatio = This.oForm.Width / This.nOriginalWidth
	 &&MESSAGEBOX(VARTYPE(m.oObject))
	 &&IF VARTYPE(m.oObject)<>'L'
	 IF VARTYPE(m.oObject)='O'
		 WITH m.oObject
		 	IF PEMSTATUS(m.oObject,'_nOriginalWidth',5)
			 	.Width =._nOriginalWidth * m.nWidthRatio
			 	IF PEMSTATUS(m.oObject,'_nOriginalHeight',5)
				 	.Height = ._nOriginalHeight * m.nHeightRatio
				 	.Top = ._nOriginalTop * m.nHeightRatio
				 	.Left = ._nOriginalLeft * m.nWidthRatio
				 ENDIF
			ENDIF
			
			IF PEMSTATUS(m.oObject,'_nOriginalFontsize',5)
				.fontSize = MAX(4,ROUND(._nOriginalFontsize*;
					IIF(ABS(m.nHeightRatio)< ABS(m.nWidthRatio),m.nHeightRatio,m.nWidthRatio),0))
			ENDIF
			
			IF PEMSTATUS(m.oObject,'_nOriginalRowHeight',5)
				.RowHeight= ._nOriginalRowheight * m.nHeightRatio
			ENDIF
			
			IF .BaseClass == 'Control' AND PEMSTATUS(m.oObject,'RepositionContents',5)
			.RepositionContents()

			ENDIF
		ENDWITH
	EndIf
ENDFUNC
*=
*=
*FUNCTION Zoom
*=
*=
	FUNCTION zoom
		LOCAL loform
		loForm = this.oForm
		IF TYPE('_Screen.CurrentZoom') == 'N' AND TYPE('loForm') = 'O'
			DO case
				CASE _Screen.CurrentZoom > 0 and _Screen.CurrentZoom < 100 
	*== Width		
					nDisp = _Screen.Width - loForm.MinWidth
					nWidth = INT(nDisp *(_Screen.CurrentZoom/100))
					loForm.Width = loForm.MinWidth + nWidth
	*==Height				
					nScrHei = _Screen.Height -25
					nDisp = nScrHei - loForm.MinHeight
					nHeight = INT(nDisp*(_Screen.CurrentZoom/100))
					loForm.Height = loForm.MinHeight + nHeight
				CASE _Screen.CurrentZoom = 100
					loForm.WindowsState = 2
				OTHERWISE
	*=Normal(Zoom = 0)
					loform.Width =loForm.MinWidth
					loForm.Height =loForm.MinHeight
				ENDCASE
				loForm.AutoCenter = .T.
		ENDIF
	ENDFUNC
enddefine
				
				