(function (global) {
  // Estilo: ocultar POIs / labels innecesarios
  const MAP_STYLE = [
    { featureType: 'poi', stylers: [{ visibility: 'off' }] },
    { featureType: 'poi.business', stylers: [{ visibility: 'off' }] },
    { featureType: 'poi.government', stylers: [{ visibility: 'off' }] },
    { featureType: 'poi.medical', stylers: [{ visibility: 'off' }] },
    { featureType: 'poi.place_of_worship', stylers: [{ visibility: 'off' }] },
    { featureType: 'poi.school', stylers: [{ visibility: 'off' }] },
    { featureType: 'poi.park', elementType: 'labels', stylers: [{ visibility: 'off' }] },
    { featureType: 'transit', stylers: [{ visibility: 'off' }] },
    { featureType: 'road', elementType: 'labels.icon', stylers: [{ visibility: 'off' }] },
    { featureType: 'water', elementType: 'labels', stylers: [{ visibility: 'off' }] },
    { featureType: 'administrative', elementType: 'labels', stylers: [{ visibility: 'off' }] }
  ];

  function alerta(msg){
    const sb = document.getElementById('snackbar');
    if(!sb) return;
    sb.innerText = msg;
    sb.className = 'show';
    setTimeout(() => sb.className = sb.className.replace('show',''), 3000);
  }

  function crearEtiqueta(texto, posicion, map, visible=true){
    const div = document.createElement('div');
    div.className = 'custom-label';
    div.textContent = texto;
    div.style.opacity = visible ? '1' : '0';

    const overlay = new google.maps.OverlayView();
    overlay.onAdd = function(){ this.getPanes().overlayMouseTarget.appendChild(div); };
    overlay.draw = function(){
      const proj = this.getProjection();
      const pos = proj.fromLatLngToDivPixel(posicion);
      div.style.left = (pos.x - div.offsetWidth/2) + 'px';
      div.style.top  = (pos.y - div.offsetHeight/2) + 'px';
    };
    overlay.onRemove = function(){ if(div.parentNode) div.parentNode.removeChild(div); };
    overlay.setVisible = (show)=>{ div.style.opacity = show ? '1' : '0'; };
    overlay.setMap(map);
    return overlay;
  }

  function centro(latLngs){
    let lat=0, lng=0;
    latLngs.forEach(c => { lat += c.lat(); lng += c.lng(); });
    return new google.maps.LatLng(lat/latLngs.length, lng/latLngs.length);
  }

  function latLngsFromArray(arr){
    return (arr || []).map(c => new google.maps.LatLng(c.lat, c.lng));
  }

  function polygon(map, path, opt){
    return new google.maps.Polygon(Object.assign({
      paths: path, map, clickable: false
    }, opt || {}));
  }

  function addBlockingOverlay(){
    try{
      const ov = document.createElement('div');
      ov.setAttribute('data-geo-readonly','');
      ov.style.position = 'fixed';
      ov.style.inset = '0';
      ov.style.zIndex = '2147483647';
      ov.style.background = 'transparent';
      ov.style.pointerEvents = 'auto';
      document.body.appendChild(ov);
    }catch(e){ /* no-op */ }
  }

  global.GEO = {
    MAP_STYLE,
    alerta,
    crearEtiqueta,
    centro,
    latLngsFromArray,
    polygon,
    addBlockingOverlay
  };
})(window);
